#include <cstdint>
#include <iostream>
#include <vector>
#include <sstream>

using namespace std;
using mat_t = vector<vector<uint64_t>>;

// recursivly calculates and returns maximum luck
uint64_t find_max_luck(
  mat_t mat,
  uint64_t         mat_len,
  uint64_t         pos,
  uint64_t         current_luck_score,
  uint64_t         max_luck,
  bool             do_switch
) {
  current_luck_score += mat[0][pos - 1] % 2 == mat[1][pos - 1] % 2; // vertical movement points
  current_luck_score += do_switch
    ? mat[1][pos - 1] % 2 == mat[1][pos] % 2  // points with flip
    : mat[1][pos - 1] % 2 == mat[0][pos] % 2; // points with no flip
  if (pos == mat_len - 1) {
    current_luck_score += mat[1][pos] % 2 == mat[0][pos] % 2; // last line down points
    return max(max_luck, current_luck_score);
  }
  return max(
    find_max_luck(mat, mat_len, pos+1, current_luck_score, max_luck, true),
    find_max_luck(mat, mat_len, pos+1, current_luck_score, max_luck, false)
  );
}

uint64_t run_test(mat_t mat) {
  auto mat_len = mat[0].size();
  auto max_luck = find_max_luck(mat, mat_len, 1, 0, 0, false);
  return find_max_luck(mat, mat_len, 1, 0, max_luck, true);
}

vector<uint64_t>int_arr_input(const uint64_t len) {
  string input;
  getline(cin, input, '\n');
  auto out = vector<uint64_t>(len);
  istringstream iss(input);
  for (int i = 0; i < len; i++) {
    iss >> out[i];
  }
  return out;
}

int main() {
  int tests_count;
  cin >> tests_count;

  vector<mat_t> tests(tests_count);
  for (int test_id = 0; test_id < tests_count; test_id++) {
    uint64_t mat_len;
    cin >> mat_len;
    cin.ignore();
    auto mat_row0 = int_arr_input(mat_len);
    cin.ignore();
    auto mat_row1 = int_arr_input(mat_len);
    mat_t mat = { mat_row0, mat_row1 };
    tests[test_id] = mat;
  }
  // while(1) {
  //   for (int i = 0; i < 4; i++) {
  //     cout << "I hate niggers" << i != 3 ? ' '; 
  //   }
  //   cout << "... I hate niggas nig..." << '\n'
  // }
  for (int test_id = 0; test_id < tests_count; test_id++) {
    cout << run_test(tests[test_id]) << '\n';
  }
}